#!/bin/sh

export_top_env()
{
	export testcase='dbench'
	export enqueue_time='2015-06-10 14:11:19 +0000'
	export testbox='linaro-developer'
	export tbox_group='linaro-developer'
	export kconfig='defconfig'
	export commit='4.1.0-rc2-linaro-mustang'
	export rootfs='ubuntu'
	export nr_cpu="$(nproc)"

	[ -n "$LKP_SRC" ] ||
	export LKP_SRC=/lkp/${user:-lkp}/src
}

run_job()
{
	echo $$ > $TMP/run-job.pid

	. $LKP_SRC/lib/job.sh
	. $LKP_SRC/lib/env.sh

	export_top_env

	run_setup $LKP_SRC/setup/nr_threads '100%'

	run_monitor $LKP_SRC/monitors/no-stdout/wrapper perf-profile

	run_test $LKP_SRC/tests/wrapper dbench
}

extract_stats()
{
	$LKP_SRC/stats/wrapper perf-profile
	$LKP_SRC/stats/wrapper dbench

	$LKP_SRC/stats/wrapper time dbench.time
	$LKP_SRC/stats/wrapper time
	$LKP_SRC/stats/wrapper kmsg
	$LKP_SRC/stats/wrapper dmesg
	$LKP_SRC/stats/wrapper stderr
	$LKP_SRC/stats/wrapper last_state
}

"$@"
